/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import vazkii.botania.api.recipe.IOrechidRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeSerializerBase;
import vazkii.botania.common.crafting.StateIngredientHelper;

public class RecipeOrechid
implements IOrechidRecipe {
    private final ResourceLocation id;
    private final Block input;
    private final StateIngredient output;
    private final int weight;

    public RecipeOrechid(ResourceLocation id, Block input, StateIngredient output, int weight) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.weight = weight;
    }

    @Override
    public Block getInput() {
        return this.input;
    }

    @Override
    public StateIngredient getOutput() {
        return this.output;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipeTypes.ORECHID_TYPE;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeTypes.ORECHID_SERIALIZER;
    }

    public static class Serializer
    extends RecipeSerializerBase<RecipeOrechid> {
        public RecipeOrechid fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            ResourceLocation blockId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"input"));
            Block input = (Block)Registry.f_122824_.m_6612_(blockId).orElseThrow(() -> new JsonSyntaxException("Unknown block id: " + blockId));
            StateIngredient output = StateIngredientHelper.tryDeserialize(GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            if (output == null) {
                throw new JsonSyntaxException("Unknown output: " + GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            }
            int weight = GsonHelper.m_13927_((JsonObject)json, (String)"weight");
            return new RecipeOrechid(recipeId, input, output, weight);
        }

        public RecipeOrechid fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Block input = (Block)Registry.f_122824_.m_7942_(buffer.m_130242_());
            StateIngredient output = StateIngredientHelper.read(buffer);
            int weight = buffer.m_130242_();
            return new RecipeOrechid(recipeId, input, output, weight);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RecipeOrechid recipe) {
            buffer.m_130130_(Registry.f_122824_.m_7447_((Object)recipe.getInput()));
            recipe.getOutput().write(buffer);
            buffer.m_130130_(recipe.getWeight());
        }
    }
}

